*******************************************************
* KEYPAD.SRC                                          *
*                                                     *
* This program reads a hex codes from a keypad        *
* attached to the 6821, Port A.  The code is          *
* converted to ASCII and sent to the console.         *
*******************************************************
PIA      EQU      $010001   ;6821 PIA base address
CRA      EQU      1*2       ;Control Register A
HTOA     EQU      $00099E   ;MON68K subroutine (V4.4)

         ORG      $8000
KEYPAD   MOVEA.L  #PIA,A0       ;A0 points to DDRA
         MOVE.B   #$0F,(A0)     ;bits PA0-PA3 = outputs
         MOVE.B   #$04,CRA(A0)  ;A0 points to Port A
         MOVEA.L  #BANNER,A1    ;send test message to
         TRAP     #2            ;   console
LOOP     BSR.S    IN_HEX        ;get a code from keypad
         BSR.L    HTOA          ;convert to ASCII
         TRAP     #1            ;send to console
         BRA      LOOP          ;repeat

*******************************************************
* IN_HEX - INput a HEXadecimal code from keypad       *
*                                                     *
* This routine includes debouncing.  It calls GET_KEY *
* continually until 50 consecutive calls return with  *
* C = 1, indicating a key is pressed.  It then calls  *
* GET_KEY continually until 50 consecutive calls      *
* return with C = 0, indicating the key is released.  *
*                                                     *
*        ENTER:   A0 points to PIA, Port A            *
*        EXIT:    D0[0:3] contains hexadecimal code   *
*                 D0[4:31] cleared                    *
*                 all other registers intact          *
*        USES:    GET_KEY                             *
*******************************************************
IN_HEX   MOVEM.W  D1-D2,-(SP)
OVER     MOVE.W   #49,D1        ;use D1 as counter
AGAIN    BSR.S    GET_KEY       ;key pressed?
         BCC      OVER          ;no:  start over again
         DBRA     D1,AGAIN      ;yes: check again
         MOVE.B   D0,D2         ;save code in D2
OVER2    MOVE.W   #49,D1        ;wait for key release
AGAIN2   BSR.S    GET_KEY       ;key released?
         BCS      OVER2         ;no:  start over again
         DBRA     D1,AGAIN2     ;yes: check again
         MOVE.B   D2,D0         ;restore code
         MOVEM.W  (SP)+,D1-D2
         RTS

*******************************************************
* GET_KEY - GET a scanned code from KEYpad            *
*                                                     *
*        ENTER:   A0 points to PIA, Port A            *
*        EXIT:    C = 0 if no key hit                 *
*                 C = 1 if key hit and                *
*                 D0[0:3] contains hex code           *
*                 D0[4:31] cleared                    *
*        USES:    no subroutines                      *
*******************************************************
GET_KEY  MOVEM.W  D1-D3,-(SP)
         CLR.W    D0            ;build hex. code in D0
         MOVE.B   #$FE,D1       ;start with column 0
         MOVE.W   #3,D2         ;use D2 as counter
NEXT     MOVE.B   D1,(A0)       ;activate column line
         MOVE.B   (A0),D0       ;read PIA Port A
         ANDI.B   #$F0,D0       ;isolate row lines
         CMP.B    #$F0,D0       ;any row line active?
         BNE.S    KEY_HIT       ;yes: check it out
         ROL.B    #1,D1         ;no:  rotate col. code
         DBRA     D2,NEXT       ;     and check next
         ANDI.W   #$FFFE,SR     ;if reached here, no
         BRA.S    EXIT          ;   key hit, clear C
KEY_HIT  CLR.B    D3            ;build code in D3
KEY2     ROR.B    #1,D1         ;rotate column code
         BCC.S    SKIP          ;found active column?
         ADDQ.B   #1,D3         ;no:  add weight of 1 &
         BRA      KEY2          ;     check again
SKIP     ROR.B    #4,D0         ;yes: align row code
KEY3     ROR.B    #1,D0         ;rotate row code
         BCC.S    SKIP2         ;found active code?
         ADDQ.B   #4,D3         ;no:  add weight of 4 &
         BRA      KEY3          ;     check again
SKIP2    MOVE.B   D3,D0         ;yes: put code in D0
         ORI.W    #1,SR         ;set C-bit in CCR
EXIT     MOVEM.W  (SP)+,D1-D3   ;restore registers &
         RTS                    ;return
BANNER   DC.B     $0D,$0A,'*** TEST KEYPAD ***'
         DC.B     $0D,$0A,0
         END      KEYPAD
